# -*- coding: utf-8 -*-

import pandas as pd
import numpy as np
def derivative(data,t):
    """
		This function calculates the derivative of a data trace in time.

		Inputs
		------
		data: numpy array
			data trace from which the derivative is to be calculated
		t: numpy array
			time array from for derivative calculation (defined UNIX time)

		Outputs
		-------
		dt: numpy array
			the derivative of your data
		t_dt: numpy array 
			the timeseries associated with dt

		NOTE: 
		This derivative is calculated using the finite forward difference quotient. 
		As a result, the derivative and associated time array are one entry shorter than the input arrays.
		In essence, the finite derivative of the trace "exists" at the earlier timestamp used to calculate the derivative
		.
		For more information, please see: https://en.wikipedia.org/wiki/Finite_difference


	"""
    
    # Initialize derivative and time associated with derivative
    
    dt = pd.DataFrame(np.zeros([data.size - 1,1], dtype = float))
    t_dt = pd.DataFrame(np.zeros([t.size - 1,1], dtype = float))
    for cnt in range(data.size - 1):
        t_dt.iloc[cnt] = t.iloc[cnt]
        dt.iloc[cnt] = (data.iloc[cnt+1] - data.iloc[cnt])/(t.iloc[cnt+1] - t.iloc[cnt])
        
    return dt, t_dt