# -*- coding: utf-8 -*-
"""
ex_save_temperature.py
Created : 3/8/2021

Description:
    This example uses the Multi-PIP analysis suite to upload and data file and save the temperature data to another CSV.
"""

# Import the necessary packages
from pathlib import Path
import sys

# Import the Multi-PIP Analysis Suite
include_path = "../src"
sys.path.append(str(Path(include_path)))
from MP_analysis_suite import MP


# Input the relative path to your file and your filename
file = "./test_data_Multi-PIP.CSV"


# Initialize and load the file
PIP = MP()
PIP.load(file)

'''
Note: 
    The MP.save_data function has multiple parameters the user can adjust that control
    the where and what of data saving.
    All the parameters are OPTIONAL. 
    
    Parameters
    ----------
        path (string): The path and filename to save to (default is a custom a csv file with a timestamp in ./)
        df (pandas dataframe): The Multi-PIP dataframe you would like to save (defaults to MP.data)
        P (boolean): If 'True' (default), phase data is included in the save, otherwise it is omitted.
        RI (boolean): If 'True' (default), real and imaginary data is included in the save, otherwise it is omitted.
        Z (boolean): If 'True' (default), impedance data is included in the save, otherwise it is omitted.
        M (boolean): If 'True' (default), magnitude data is included in the save, otherwise it is omitted.
        T (boolean): If 'True' (default), temperature data is included in the save, otherwise it is omitted.
    
    So, in this example, we set all save options except T to false. 
'''
# Save Temperature to working directory
PIP.save_data(Z = False, P = False, RI = False, M = False)