# -*- coding: utf-8 -*-
"""
ex_merge_files.py
Created : 2/2/2022

Description:
    This example uses the Multi-PIP analysis suite to merge two Multi-PIP data files.  
"""

# Import the necessary packages
from pathlib import Path
import sys

# Import the Multi-PIP Analysis Suite
include_path = "./../src"
sys.path.append(str(Path(include_path)))
from MP_analysis_suite import MP


# Input the relative path to the files you'd like to merge
file1 = "./Leaves_1-8_merge.CSV"
file2 = "./Leaves_9-16_merge.CSV"

merged_filepath = "./Leaves_1-16.CSV"

# Initialize and load the files in seperate Multi-PIP objects
PIP1 = MP()
PIP1.load(file1)
PIP2 = MP()
PIP2.load(file2)

# Merge the files using the '+' operator
'''
Note:
    This only works for two Multi-PIP files, merging with any other filetypes is not supported. 
'''
Merged_PIP = PIP1+PIP2

# You may now interact with Merged_PIP like you would any other MP (Multi-PIP) object.
# For example, here we save the merged data to the filepath we specified earlier.
Merged_PIP.save_data(path = merged_filepath)

