# -*- coding: utf-8 -*-
"""
ex_filter_and_plot_NDZI.py
Created : 3/17/2021

Description:
    This example uses the Multi-PIP analysis suite to filter loaded data based on a low frequency impedance
    window of 0 - 1 MegaOhm and plot NDZI.
"""

# Import the necessary packages
from pathlib import Path
import sys

# Import the Multi-PIP Analysis Suite
include_path = "./../src"
sys.path.append(str(Path(include_path)))
from MP_analysis_suite import MP


# Input the relative path to your file and your filename
file = "./test_data_Multi-PIP.CSV"


# Initialize and load the file
PIP = MP()
PIP.load(file)

# Filter data based on low frequency impedance window of 0-1 MegaOhm.
f_data = PIP.z_window(0, 1000)

# Plot NDZI of unfiltered data for the probe pair 'A1C1', to see figures navigate to the 'Plots' tab in Spyder.
fig, ax = PIP.plot_NDZI(prb_pair = 'A1C1')
# Change title of the figure to indicate unfiltered data
fig.suptitle('Unfiltered data')

# Plot NDZI of filtered data for the probe pair 'A1C1'
fig_f, ax_f = PIP.plot_NDZI(prb_pair = 'A1C1', df = f_data )
# Change title of the figure to indicate filtered data
fig_f.suptitle('Filtered data. Low frequency impedance cap of 1 MegaOhm')