# -*- coding: utf-8 -*-
"""
ex_compute_plot_save_NDZI.py
Created : 3/8/2021

Description:
    This example uses the Multi-PIP analysis suite to calculate the NDZI, plot it, and save the data to an external CSV.
"""

# Import the necessary packages
from pathlib import Path
import sys

# Import the Multi-PIP Analysis Suite
include_path = "./../src"
sys.path.append(str(Path(include_path)))
from MP_analysis_suite import MP


# Input the relative path to your file and your filename
file = "./test_data_Multi-PIP.CSV"


# Initialize and load the file
PIP = MP()
PIP.load(file)

# Compute and plot NDZI for 100 Hz and 95000 Hz. 
PIP.calc_NDZI(f_l = 100, f_h = 95000)

# Plot NDZI for the probe pair 'A1C1', to see figures navigate to the 'Plots' tab in Spyder.
PIP.plot_NDZI(prb_pair = 'A1C1')

'''
Note:
    NDZI has a completely different structure than raw Multi-PIP data (1 point every 2 frequencies).
    As a result, saving NDZI is done through its own method save_NDZI, rather than save_data.
'''
# Save NDZI to working directory
PIP.save_NDZI()