# Welcome to the Multi-PIP Analysis Suite.
This python module is desgined to handle interacting with Multi-PIP data files. 

## Core
At the core of the module is the "MP" (Multi-PIP) python object. 
This object has a couple of key attributes whose values are set via loading a Multi-PIP data file.
1. MP.version: The version of the Multi-PIP, e.g., '2.04'. 
2. MP.name: The name of the Multi-PIP, e.g., 'Multi-PIP 1'.
3. MP.metadata: Metadata loaded from the Multi-PIP data file, contains start and end times and dates, version and name.
4. MP.data: Time series data loaded from the Multi-PIP data file. 
5. MP.NDZI: The normalized differential impedance index (NDZI) that is calculated by performing an operation on impedances associated with two frequencies

When writing custom scripts a user will often be interacting with MP.data, which is a pandas dataframe that can be filtered using the python pandas module. 

## Examples
The Multi-PIP analysis suite is accompanied by a large set of examples to help orient a new user.
All examples are contained inside the "examples" directory and are designed to run out-of-the-box in the Spyder IDE.
Please visit the Multi-PIP Analysis Suite page on https://support.growvera.com for setup instructions.

A list of all examples along with breif descriptions are included below. 
1. ex_compute_plot_save_NDZI.py: Calculate, plot, and save NDZI.
2. ex_filter_and_plot_NDZI.py: Filter and plot NDZI.
3. ex_filter_plot_save_Impedance.py: Filter, plot, and save an impedance associated with a particular frequency.
4. ex_merge_files.py: Merge two Multi-PIP data files and save the result.
5. ex_plot_impedance_vs_time.py: Plot impedance versus time.
6. ex_plot_phase_vs_time.py: Plot phase versus time.
7. ex_plot_z_h_vs_z_l.py: Plot a high frequency impedance versus a low frequency impedance.
8. ex_save_temperature.py: Save temperature associated with Multi-PIP data. 

## Methods of the MP class
The examples make use of the MP's methods to accomplish different tasks.
The methods have been designed to accelerate development of a user's custom scripts.

The methods contained in MP are grouped by functionality and outlined with brief descriptions below.
    
Data I-O and Filtering Related Methods
------------------------
    load : Imports Multi-PIP data from CSV.
    + (__add__): Merges two Multi-PIP objects.
    save_NDZI : Save NDZI data as a CSV.
    save_data: Save Multi-PIP data to a CSV file. (Options to save certain columns included)
    z_window : An impedance filter that discards all data outside a user-defined window.

Calculation Related Methods
---------------------------
    calc_NDZI : Calculates NDZI for all probe pairs.

Plotting Related Methods
------------------------
    plot_NDZI : Plots NDZI for one probe pair.
    plot_z_vs_t : Plots impedance versus time for one probe pair.
    plot_z_h_vs_z_l : Plot high impedance versus low impedance for one probe pair.
    plot_T_vs_t : plot |Phase angle| versus time for a particular frequency and probe pair.
    plot_z_ratio_vs_time : Plot ratio of impedance (low frequency) / impedance (high frequency).
    plot_R_vs_I : Plot real versus imaginary for all frequencies for a particular probe pair.
    plot_z_h_vs_T_h : Plot impedance versus |phase angle| for a particular frequency.
    
Formatting and Checking Related Methods
---------------------------------------
    format_datetime_plot : Sets title and axis format for datetime plot.
    prb_pair_name_crosscheck : Crosschecks probe pair with probe pair name.

    
Please see method descriptions within src/MP.py for more detailed documentation on each of the methods.

## Support
For questions and concerns, please contact Growvera support at support.growvera.com 