# -*- coding: utf-8 -*-
"""
ex_filter_plot_save_Impedance.py
Created : 3/17/2021

Description:
    This example uses the Multi-PIP analysis suite to filter loaded data based on a low frequency impedance
    window of 0 - 1 MegaOhm. The filtered data is then plotted before being saved to a CSV.
"""

# Import the necessary package
import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.backends.backend_pdf import PdfPages
from pathlib import Path
import sys
include_path = "./../src"
sys.path.append(str(Path(include_path)))
from MP_analysis_suite import *


# Input the relative path to your file and your filename
file = ".\\test_data_Multi-PIP.CSV"


# Initialize and load the file
PIP = MP()
PIP.load(file)

# Filter data based on low frequency impedance window of 0-1 MegaOhm.
f_data = PIP.z_window(0, 1000)

# Plot Impedance of unfiltered data for the probe pair 'A1C1' and frequency 100 Hz, to see figures navigate to the 'Plots' tab in Spyder.
fig, ax = PIP.plot_z_vs_t(freq = 100, prb_pair = 'A1C1')
# Change title of the figure to indicate unfiltered data
fig.suptitle('Unfiltered data')

# Plot Impedance of filtered data for the probe pair 'A1C1' and frequency 100 Hz.
fig_f, ax_f = PIP.plot_z_vs_t(freq = 100, prb_pair = 'A1C1', df = f_data )
# Change title of the figure to indicate filtered data
fig_f.suptitle('Filtered data. Low frequency impedance cap of 1 MegaOhm')

# Save the filtered impedance data to a CSV
PIP.save_Impedance(df = f_data)