# -*- coding: utf-8 -*-
"""
ex_compute_plot_save_NDZI.py
Created : 3/8/2021

Description:
    This example uses the Multi-PIP analysis suite to calculate the NDZI, plot it, and save the data to an external CSV.
"""

# Import the necessary package
import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.backends.backend_pdf import PdfPages
from pathlib import Path
import sys
include_path = "./../src"
sys.path.append(str(Path(include_path)))
from MP_analysis_suite import *


# Input the relative path to your file and your filename
file = "test_data_Multi-PIP.CSV"


# Initialize and load the file
PIP = MP()
PIP.load(file)

# Compute and plot NDZI for 100 Hz and 95000 Hz. 
PIP.calc_NDZI(f_l = 100, f_h = 95000)

# Plot NDZI for the probe pair 'A1C1', to see figures navigate to the 'Plots' tab in Spyder.
PIP.plot_NDZI(prb_pair = 'A1C1')

# Save NDZI to working directory
PIP.save_NDZI()