# -*- coding: utf-8 -*-
"""
ex_plot_impedance_vs_time.py
Created : 3/4/2021

Description:
    This example uses the Multi-PIP analysis suite to create plots impedance versus time for all the probe pair names found in the imported data.
    The figures are saved to a pdf file in the same folder as this example. 
"""

# Import the necessary package
import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.backends.backend_pdf import PdfPages
import sys
sys.path.append('../src/')
from MP_analysis_suite import *


# Input the relative path to your file and your filename
file = ".\\test_data_Multi-PIP.CSV"

# Relative path and file name for output pdf
pdf = ".\\impedance_vs_time_test_data.pdf"

# Initialize and load the file
PIP = MP()
PIP.load(file)

# Find probe pair names in data
prb_pair_names = pd.unique(PIP.data['probe pair name'])

# Open pdf file to save figures to
pdf = PdfPages(pdf)

for i in prb_pair_names:

    # Plot impedance for probe pair name
    fig, ax = PIP.plot_z_vs_t(freq = 100, prb_pair_name = i)
    
    # Save figure to pdf
    pdf.savefig(fig)

# Close pdf
pdf.close()