import pandas as pd
from datetime import datetime, timedelta
def format_datetime_plot(t_i,t_f):
    """
    This function sets axis datetime format options and title date information based on elapsed time for windows. 
    
        Input
        -----
        t_i : pandas datetime
        Initial time
        t_f : pandas datetime
        Final Time

        Output
        ------
        ax_form: string
            Axis datetime format
        title_form: string
            Date data to include in title e.g. 2021/05/07 -----> 2021/08/19
    """
    
    # Calculate elapsed time between initial and final
    delta_t = t_f - t_i 
    # Determine title and axis format based off elapsed time
    if delta_t <= timedelta(seconds = 300):
        ax_form = "%M:%S"
        title_form = t_f.strftime("%Y/%m/%d")+", hour "+t_f.strftime("%H")
    elif (delta_t > timedelta(seconds = 300))&(delta_t <= timedelta(minutes = 80)):
        ax_form = "%H:%M"
        title_form = t_i.strftime("%Y/%m/%d")+" -----> "+t_f.strftime("%Y/%m/%d")
    elif (delta_t > timedelta(minutes = 80))&(delta_t <= timedelta(hours = 72)):
        ax_form = "%H:%M"
        title_form = t_i.strftime("%Y/%m/%d")+" -----> "+t_f.strftime("%Y/%m/%d")
    elif (delta_t > timedelta(hours = 72))&(delta_t <= timedelta(days = 14)):
        ax_form = "%m/%d"
        title_form = t_i.strftime("%Y/%m/%d")+" -----> "+t_f.strftime("%Y/%m/%d")
    else: 
        ax_form = "%m/%d"
        title_form = t_i.strftime("%Y/%m/%d")+" -----> "+t_f.strftime("%Y/%m/%d")
        
        
    return title_form,ax_form