import numpy as np
def calc_NDZI(z_l,z_h):
	""" 
	Calculate NDZI from high and low impedance

	Last Modified: 2/12/2021
	
	Inputs
	------
	z_l: dataframe
		Low frequency impedance data from pandas dataframe
	z_h: dataframe
		High frequency impedance data from pandas dataframe

	Outputs
	-------
	NDZI: numpy array
		values range from [-100,100]
		
	"""
	NDZI = np.divide(np.array(z_l) - np.array(z_h) , np.array(z_l) + np.array(z_h))*100

	return NDZI